' Construire un alias vers System.Enum
Imports DotNetEnum = System.Enum

' Notre numration (stockage d'octets).
Enum EmpType As Byte
    Manager = 10
    Grunt = 1
    Contractor = 100
    VP = 9
End Enum

Module Module1

    ' Le paramtre est une numration.
    Public Sub AskForBonus(ByVal e As EmpType)
        Select Case (e)
            Case EmpType.Contractor
                Console.WriteLine("Vous avez dj reu assez dargent...")
            Case EmpType.Grunt
                Console.WriteLine("Vous devez plaisanter...")
            Case EmpType.Manager
                Console.WriteLine("Que pensez-vous plutt des stock options ?")
            Case EmpType.VP
                Console.WriteLine("TRS BIEN, Monsieur !")
        End Select
    End Sub

    Sub Main()
        Dim fred As EmpType
        fred = EmpType.VP
        Console.WriteLine("Fred est: {0}", fred.ToString())

        AskForBonus(fred)

        ' Rcuprer le type sous-jacent.
        Console.WriteLine(DotNetEnum.GetUnderlyingType(fred.GetType()))

        ' Notation alternative.
        Console.WriteLine(DotNetEnum.GetUnderlyingType(fred.GetType()))

        ' Rcuprer le type de Fred.
        Console.WriteLine("Vous tes un {0}", DotNetEnum.Format(fred.GetType(), fred, "G"))

        ' Rcuprer toutes les donnes sur EmpType.
        Dim obj As Array = DotNetEnum.GetValues(fred.GetType())
        Console.WriteLine("Cette numration possde  {0} membres.", obj.Length)

        ' Maintenant montrer le nom de la chane et la valeur associe.
        Dim e As EmpType
        For Each e In obj
            Console.Write("Nom de la chane: {0}", DotNetEnum.Format(fred.GetType(), e, "G"))
            Console.Write(" ({0})", DotNetEnum.Format(fred.GetType(), e, "D"))
            Console.WriteLine(" hex: {0}", DotNetEnum.Format(fred.GetType(), e, "X"))
        Next

        ' Est-ce-que EmpType a une valeur SalePerson?
        If (DotNetEnum.IsDefined(fred.GetType(), "SalesPerson")) Then
            Console.WriteLine("Oui, nous avons des vendeurs.")
        Else
            Console.WriteLine("Non, nous ne ralisons pas de bnfices.....")
        End If

        Dim joe As EmpType = EmpType.VP
        Dim fran As EmpType = EmpType.Grunt

        If (joe < fran) Then
            Console.WriteLine("Joe rapporte moins que Fran")
        Else
            Console.WriteLine("Fran rapporte moins que Joe")
        End If
    End Sub
End Module
